/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.obj;

import ec.gob.sri.anexo.texto.util.StringUtil;
import ec.gob.sri.dimm.api.modelo.ObjetoModelo;
import ec.gob.sri.dimm.api.modelo.ObjetoModeloSucesorValidableAnotado;
import ec.gob.sri.dimm.api.modelo.persistencia.Importable;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionEditable;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.modelo.validacion.ValidacionIdentificacion;
import ec.gob.sri.dimm.ats.modelo.obj.Periodo;
import ec.gob.sri.dimm.ats.modelo.util.Constantes;
import ec.gob.sri.dimm.data.impl.UtilCatalogosATS;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Sujeto
extends ObjetoModeloSucesorValidableAnotado<ObjetoModelo>
implements InformacionEditable<Sujeto>,
Importable {
    private static final long serialVersionUID = 7416431756231522045L;
    public static final String C_TIPO_IDENTIFICACION = "tipoIdentificacion";
    public static final String C_IDENTIFICACION = "identificacion";
    public static final String C_RAZON_SOCIAL = "razonSocial";
    public static final String C_TIPO_PROVEEDOR = "tipoProveedor";
    protected static final String DEBE_SELECCIONAR_EL_TIPO_DE_CLIENTE = "Debe seleccionar el tipo de cliente";
    protected static final String DEBE_REGISTRAR_LA_RAZON_SOCIAL = "Debe registrar la raz\u00f3n social";
    protected static final String DEBE_SER_SOLO_LETRAS_Y_NUMEROS = " debe contener solo letras y n\u00fameros y m\u00ednimo 1 caracter";
    protected String tagTipoIdentifacion;
    protected String tagIdentificacion;
    protected String codigoTransaccion;
    @NotNull(message="Debe seleccionar el tipo de identificaci\u00f3n")
    private String tipoIdentificacion;
    private String descripcionTipoIdentificacion;
    @NotNull(message="Debe escribir el n\u00famero de identificaci\u00f3n")
    private String identificacion;
    protected String razonSocial;
    protected String tipoProveedor;
    protected String descripcionTipoProveedor;

    public Sujeto() {
    }

    public Sujeto(String tagTipoIdentifacion, String tagIdentificacion, String codigoTransaccion) {
        this.tagTipoIdentifacion = tagTipoIdentifacion;
        this.tagIdentificacion = tagIdentificacion;
        this.codigoTransaccion = codigoTransaccion;
    }

    protected ResultadoValidacion validarObjeto() {
        ResultadoValidacion resultado = new ResultadoValidacion();
        if ("L".equals(this.tipoIdentificacion) ? !ValidacionIdentificacion.validarOtrasIdentificaciones((String)this.tipoIdentificacion, (String)this.identificacion, (ResultadoValidacion)resultado, (Integer)3, (Integer)13, (String)"PLACA o RAMV/CPN").esEstadoExitoso() : !ValidacionIdentificacion.validarTodaIdentificacion((String)this.tipoIdentificacion, (String)this.identificacion, (ResultadoValidacion)resultado, (Integer)3, (Integer)13).esEstadoExitoso()) {
            return resultado;
        }
        if (!this.validacionExtra(resultado).esEstadoExitoso()) {
            return resultado;
        }
        return resultado.pasarValidacion();
    }

    public Sujeto crearCopiaEdicion() {
        Sujeto copia = new Sujeto();
        copia.setTipoIdentificacion(this.tipoIdentificacion);
        copia.setIdentificacion(this.identificacion);
        copia.setDescripcionTipoIdentificacion(this.descripcionTipoIdentificacion);
        copia.setPropietario(this.propietario);
        return copia;
    }

    public void actualizarInformacion(Sujeto copiaEdicion) {
        this.setTipoIdentificacion(copiaEdicion.getTipoIdentificacion());
        this.setIdentificacion(copiaEdicion.getIdentificacion());
        this.setDescripcionTipoIdentificacion(copiaEdicion.getDescripcionTipoIdentificacion());
        this.setTipoProveedor(copiaEdicion.getTipoProveedor());
        this.setDescripcionTipoProveedor(copiaEdicion.getDescripcionTipoProveedor());
        this.setRazonSocial(copiaEdicion.getRazonSocial());
    }

    protected ResultadoValidacion validacionExtra(ResultadoValidacion resultado) {
        return resultado;
    }

    public Object importar(Element elemento, Map<String, Element> mapaData) {
        NodeList valorList = elemento.getElementsByTagName(this.tagTipoIdentifacion);
        Element eValor = (Element)valorList.item(0);
        this.tipoIdentificacion = UtilCatalogosATS.crearInstancia().obtenerTipoIdentificacionSecuencia(this.codigoTransaccion, eValor.getTextContent().trim());
        this.descripcionTipoIdentificacion = Constantes.CATALOGOS_SUJETO.get(this.getTipoIdentificacion());
        valorList = elemento.getElementsByTagName(this.tagIdentificacion);
        eValor = (Element)valorList.item(0);
        this.identificacion = eValor.getTextContent().trim();
        return this;
    }

    public String getTipoIdentificacion() {
        return this.tipoIdentificacion;
    }

    public String getIdentificacion() {
        return this.identificacion;
    }

    public String getDescripcionTipoIdentificacion() {
        return this.descripcionTipoIdentificacion;
    }

    public void setTipoIdentificacion(String tipoIdentificacion) {
        String oldValue = this.tipoIdentificacion;
        this.tipoIdentificacion = StringUtil.isNullOrEmpty((String)tipoIdentificacion) ? tipoIdentificacion : tipoIdentificacion.toUpperCase();
        this.firePropertyChange(C_TIPO_IDENTIFICACION, oldValue, this.tipoIdentificacion);
    }

    public void setIdentificacion(String identificacion) {
        String oldValue = this.identificacion;
        this.identificacion = StringUtil.isNullOrEmpty((String)identificacion) ? identificacion : identificacion.toUpperCase();
        this.firePropertyChange(C_IDENTIFICACION, oldValue, this.identificacion);
    }

    public void setDescripcionTipoIdentificacion(String descripcionTipoIdentificacion) {
        this.descripcionTipoIdentificacion = descripcionTipoIdentificacion;
    }

    protected boolean validarFormatoRazonSocial() {
        Pattern patron = Pattern.compile("^[A-Z0-9]{1}[A-Z0-9\\s]{0,499}$");
        Matcher matcher = patron.matcher(this.getRazonSocial());
        return matcher.matches();
    }

    protected ResultadoValidacion validarRazonSocial(Periodo periodo, String modulo, ResultadoValidacion resultado) {
        if ("P".equals(this.getTipoIdentificacion()) && periodo.isAnexoEnPeriodoDesdeMayo2016()) {
            if (StringUtil.isNullOrEmpty((String)this.getRazonSocial())) {
                return resultado.fallarValidacion(DEBE_REGISTRAR_LA_RAZON_SOCIAL);
            }
            if (!this.validarFormatoRazonSocial()) {
                return resultado.fallarValidacion("La raz\u00f3n social del " + modulo + DEBE_SER_SOLO_LETRAS_Y_NUMEROS);
            }
        }
        return resultado;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.identificacion == null ? 0 : this.identificacion.hashCode());
        result = 31 * result + (this.tipoIdentificacion == null ? 0 : this.tipoIdentificacion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Sujeto other = (Sujeto)((Object)obj);
        if (this.identificacion == null ? other.identificacion != null : !this.identificacion.equals(other.identificacion)) {
            return false;
        }
        return !(this.tipoIdentificacion == null ? other.tipoIdentificacion != null : !this.tipoIdentificacion.equals(other.tipoIdentificacion));
    }

    public String getRazonSocial() {
        return this.razonSocial;
    }

    public void setRazonSocial(String razonSocial) {
        String oldValue = this.razonSocial;
        this.razonSocial = razonSocial;
        this.firePropertyChange(C_RAZON_SOCIAL, oldValue, this.razonSocial);
    }

    public String getTipoProveedor() {
        return this.tipoProveedor;
    }

    public String getDescripcionTipoProveedor() {
        return this.descripcionTipoProveedor;
    }

    public void setTipoProveedor(String tipoProveedor) {
        String oldValue = this.tipoProveedor;
        this.tipoProveedor = tipoProveedor;
        this.firePropertyChange(C_TIPO_PROVEEDOR, oldValue, this.tipoProveedor);
    }

    public void setDescripcionTipoProveedor(String descripcionTipoProveedor) {
        this.descripcionTipoProveedor = descripcionTipoProveedor;
    }
}

